﻿* Encoding: UTF-8.
*create a new dataset without Attribute-3European=0.
DATASET COPY  Survey1_Tables_attr3.
DATASET ACTIVATE Survey1_Tables_attr3.
FILTER OFF.
USE ALL.
SELECT IF (attribute_3European ~= 1).
EXECUTE.
***************************************************************************.
* To exclude  candidates who have contacted us asking to participate in the survey before we sent them the invitation in Survey A. 
USE ALL.
COMPUTE filter_$=(~(attribute_2Party_id = 3 & source=2)).
VARIABLE LABELS filter_$ 'filter_$=(~(attribute_2Party_id = 3 & source=2)) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

* To calculate the the last question answered or seen before abandonment.
USE ALL.
COMPUTE filter_$=(~(attribute_2Party_id = 3 & source=2) & emailOK=1 & category=2).
VARIABLE LABELS filter_$ 'filter_$=(~(attribute_2Party_id = 3 & source=2) & emailOK=1 & category=2) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

FREQUENCIES lastpage.

*Table 2 (for A & B1).
USE ALL.
COMPUTE filter_$=(~(attribute_2Party_id = 3 & source=2) & emailOK=1).
VARIABLE LABELS filter_$ 'filter_$=(~(attribute_2Party_id = 3 & source=2) & emailOK=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

CROSSTABS
  /TABLES=category BY survey
  /STATISTICS=CHISQ 
  /FORMAT=AVALUE TABLES
  /CELLS=COUNT COLUMN
  /COUNT ROUND CELL.


* Table 3 (item nonresponse).
USE ALL.
COMPUTE filter_$=(category=1).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*section 1.
CTABLES
  /VLABELS VARIABLES=nmisp1  survey DISPLAY=LABEL
  /TABLE nmisp1 [VALIDN F40.0, MEAN, MEDIAN]  BY 
    survey
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.

NPAR TESTS
  /M-W= nmisp1  BY survey(1 2)
  /MISSING ANALYSIS.

* Table 4 (mid-point).
USE ALL.
COMPUTE filter_$=(category=1).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*section 1.
CTABLES
  /VLABELS VARIABLES=b1ratio3  survey DISPLAY=LABEL
  /TABLE b1ratio3 [S][VALIDN F40.0, MEAN, MEDIAN]  BY survey [C]
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.


NPAR TESTS
  /M-W= b1ratio3 BY survey(1 2)
  /MISSING ANALYSIS.

*Table 5 (speeders).
USE ALL.
COMPUTE filter_$=(category=1).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*section 1.
CTABLES
  /VLABELS VARIABLES=meanflag1new survey DISPLAY=LABEL
  /TABLE meanflag1new [S][VALIDN F40.0, MEAN,MEDIAN] BY survey [C]
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.


NPAR TESTS
  /M-W= meanflag1new BY survey(1 2)
  /MISSING ANALYSIS.

*Table 6 (Straight lining) .
USE ALL.
COMPUTE filter_$=(category=1).
VARIABLE LABELS filter_$ 'category=1 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

*section 1.

CTABLES
  /VLABELS VARIABLES=slm1 survey DISPLAY=LABEL
  /TABLE slm1 [VALIDN F40.0, MEAN, MEDIAN]  BY 
    survey
  /CATEGORIES VARIABLES=survey ORDER=A KEY=VALUE EMPTY=EXCLUDE.

NPAR TESTS
  /M-W= slm1 BY survey(1 2)
  /MISSING ANALYSIS.

